/*
	File:		KodakDiconixDriver.impl.h

	Contains:	Protocol Implementation header for sample driver

	Copyright:	 1992-1994 by Apple Computer, Inc., all rights reserved.

*/

#ifndef __KODAKDRIVER_H
#define __KODAKDRIVER_H

#ifndef __DOTDRIVERS_H
	#include "DotDrivers.h"
#endif

#define DRIVERCLASSNAME		TDiconixDriver			// **Driver Protocol Name**

class TEndpoint;

typedef enum	{
	k180si = 0,
	k701
} KodakVersion;


PROTOCOL DRIVERCLASSNAME : public TDotPrinterDriver
	PROTOCOLVERSION(1.0)
{
	//  Everything in the "public" section is specified by the
	//	protocol definition in "DotDrivers.h".  Don't change it.
	
public:
	PROTOCOL_IMPL_HEADER_MACRO(DRIVERCLASSNAME);

	void 	Delete(void);

	NewtonErr	Open(void);
	NewtonErr	Close(void);
	NewtonErr	OpenPage(void);
	NewtonErr	ClosePage(void);
	NewtonErr	ImageBand(PixelMap* theBand, const Rect* minRect);
	void		CancelJob(Boolean asyncCancel);

	PrProblemResolution	IsProblemResolved(void);

	void GetPageInfo(PrPageInfo* info);
	void GetBandPrefs(DotPrinterPrefs* prefs);
	
	NewtonErr	FaxEndPage(long pageCount);		// New method for 2.0
	
	//	These two fields are automatically created by the
	//	protocol interface (see DotDrivers.h).  You will be
	//	able to access them from your code.

	//	PrintConnect*		fConnect;
	//	TPrinter*			fPrinter;


private:
	//  Driver-specific items go here, as private items.

	void		Cleanup();
	Boolean		InitConnection();
	void		SendData(Ptr data, long length);
	void		SendString(char* str);
	void		ReleaseConnection();

	TEndpoint*		fAsyncIntf;
	KodakVersion	fHWType;
	NewtonErr		fCurrentError;
};

#endif